/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package viewer;

import java.io.IOException;
import java.net.URISyntaxException;

import com.inet.report.EngineRenderData;
import com.inet.viewer.RenderData;
import com.inet.viewer.SwingViewerContext;

/**
 * This sample shows you how you can export an report without the preview in the viewer. An export dialog will pop up
 * and then the report will be exported to the file you choose.
 */
public class ExportWithoutPreview {

    private RenderData renderConnection; // This is our main render data connection - the source of our raw report data coming from our report server

    /**
     * Exports an report without the preview in the viewer.
     */
    public ExportWithoutPreview() {

        String reportLocation = "";
        try {
            reportLocation = getClass().getResource( "../sample.rpt" ).toURI().toString();
        } catch( URISyntaxException e ) {
            // Nothing to do
        }

        // then initialize the render data connection.
        renderConnection = new EngineRenderData( "report=" + reportLocation );

        // you will most likely have a report server already, so you can use the URL: http://server:port/report.rpt
        // renderConnection = new URLRenderData( "http://server:port/?report=file:c:/report1.rpt" );

        SwingViewerContext swingViewerContext = new SwingViewerContext( null );

        // export report to desired file
        swingViewerContext.export( null, renderConnection );
    }

    /**
     * Main method of this sample
     *
     * @param args arguments not used
     * @throws IOException in case of IO error (e.g. port already in use)
     */
    public static void main( String[] args ) throws IOException {
        new ExportWithoutPreview();
    }
}
